function C=Covar(D,tau)
%oblicza warto funkcji kowariancji 'c(tau)' dla sygnaw zawartych w D i
%przesunicia czasowego rwnego 'tau'
%parametry wejciowe: D - macierz skadajca si z 2 kolumn (y(n), u(n));
% tau - dana warto przesunicia sygnaw (liczba prbek przesunicia);

Y = D(:,1);
U = D(:,2);

N = size(Y,1);
Yp = zeros(N,1);

MU = (1/N)*sum(U);
MY = (1/N)*sum(Y);

Ud = U;% - MU*ones(N,1);              %odjcie wartoci rednich
Yd = Y;% - MY*ones(N,1);

if (tau>=0)
    Yp(1:(N-tau)) = Yd((1+tau):N);  
else
    Yp((1-tau):N) = Yd(1:(N+tau));  
end

CYU = (1/N)*(Ud'*Yp);                   %uwaga: normalizacja wartoci 'N'
%CYU = (1/(N-abs(tau)))*(Ud'*Yp);        %uwaga: normalizacja wartoci 'N-|tau|'

C = CYU;