% Glowny program sterowania w petli zamknietej dla robota Khepera III
% KSIS 2011: M. Michalek, D. Pazderski
% wejscie: brak
% wyjscie: ustawione zmienne globalne opisujce m. in. ruch robota

global q_old enk_old enk_const
global com r b Kspeed

N = 200;            % liczba probek

% poczatkowa konfiguracja robota
q_old = [0; 0; 0];
% przygotowanie tablic
q = zeros(N, 3);
t = zeros(N, 1);
wk = zeros(N, 2);

if (strcmp(com.Status, 'closed'))
    fopen(com);                 % otwarcie portu komunikacyjnego
end

% odczyt warunku poczatkowego licznikow kol
Kh3UstawPredkosciKol([0 0]');
Kh3EnkoderyZapytanie;
enk_old = Kh3EnkoderyOdczyt;

disp('Start');
wk_i = [0 0]';
q_i = q_old;
t_i = 0;

tic                             % rozpoczecie odliczania czasu
for i = 1:N
   
  %**********************************************************************
  % tutaj umiescic generator sygnalow referencyjnych
  % 					 oraz algorytm sterowania robotem
  %**********************************************************************

  Kh3UstawPredkosciKol(wk_i);   % wysanie predkosci zadanych do robota

  Kh3EnkoderyZapytanie;         % odczyt licznikow enkoderow
  enk = Kh3EnkoderyOdczyt;

  q_i = Kh3Odometria(enk);      % obliczenie odometrii
  t_i = toc;
    
  % przepisanie probek (do celow analizy i wizualizacji)
  q(i, :) = q_i;
  wk(i, :) = wk_i;
  t(i) = t_i;
end

Kh3UstawPredkosciKol([0 0]);    % wyzerowanie predkosci kol - zatrzymanie robota

disp('Stop');
fclose(com);                    % zamkniecie portu komunikacyjnego