%**************************************************************************
% Realizacja sterowania w ptli zamknitej dla robota MTV3 
% w rodowisku MATLAB
% Katedra Sterowania i Inynierii Systemw
% Przygotowanie: Michaek, Pazderski
% 14-11-2012
%**************************************************************************
global com
global q t wk wkd 
global T0

N = 500;   % zaoona liczba probek sterowania

% Definicja podstawowych tablic 
q = zeros(N, 3);    % konfiguracja robota
t = zeros(N, 1);    % czas
wk = zeros(N, 2);   % zmierzone prdkoci k
wkd = zeros(N, 2);  % zadane prdkjoci k
%*************************************************************************
% Miejsce na definicje pozostaych tablic w celu archiwizacji wynikw
% zwizanych z algorytmem sterowania
%
%
%
%*************************************************************************

% warunki pocztkowe
q0 = [0 0 0]';
T0 = 0;

% otwrz port
if (com.Status == 'closed')
  fopen(com);
end

MTV3InicjalizacjaRobota(q0);

disp('Start algorytmu');

% pocztkowe wartosci zdanych predkosci kol
wkd_i = [0 0]; 

i = 0;
for n=1:N

  %**********************************************************************
  % tutaj umiescic generator sygnalow referencyjnych
  % 					 oraz algorytm sterowania robotem
  %**********************************************************************
 
   MTV3UstawPredkosciKol(wkd_i);
   pause(0.035);    

   if (MTV3Odbior)              
      xi = MTV3CzytajStan;
      q_i = xi(1:3);    % bieca konfiguracja
      wk_i = xi(4:5);   % zmierzone prdkoci k
      t_i = xi(6);      % czas rzeczywisty (z pokadu robota)
      
      % przepisanie do tablic
      i = i + 1;        % numer biecej prbki pomiarw 
      q(i, :) = q_i';    
      wk(i, :) = wk_i';
      wkd(i, :) = wkd_i';
      t(i) = t_i;
    end
end

MTV3UstawPredkosciKol([0 0]);  % zatrzymanie robota
disp('Zakoczenie algorytmu');

% usunicie ostatnich zerowych elementw
if (i~=N)
    t(i:N)=[];      
    q(i:N, :)=[];  
    wk(i:N, :)=[];
    wkd(i:N, :)=[];
    % pozostae tablice analogicznie!
end

fclose(com);