function out = MTV3CzytajDane();
%**************************************************************************
% Odczyt danych sensorycznych z robota
% KSIS: Pazderski i Michaek
%**************************************************************************
% wejcie: brak
% wyjcie: out = [th x y wkl wkp t]'
%**************************************************************************
global com enc T0 buf
global konw16 konw32 konw_tim
            
    x = konw32 * buf(4:7);
    y = konw32 * buf(8:11);
    th = konw16 * buf(12:13);
    
    wkl = konw16 * buf(14:15);
    wkp = konw16 * buf(16:17);
        
    t = konw_tim * buf(18:23) - T0;
 
    % konwersja do
    if (wkl >= 2^15)
        wkl = wkl - 2^16;
    end
    if (wkp >= 2^15)
        wkp = wkp - 2^16;
    end        

    if (x >= 2^31)
        x = x - 2^32;
    end
    if (y >= 2^31)
        y = y - 2^32;
    end

    % lokalizacja w jednostkach SI
    th = th * 2 * pi/ 953;
    if (th>pi)
        th = th - 2*pi;
    end
    x = x/(2^16*1000); y =  y/(2^16*1000);
    % predkosc w jednostkach SI
    wkl = wkl / enc * 2 * pi;
    wkp = wkp / enc * 2 * pi;

    % zapisanie wynikw
    out = [th; x; y; wkl; wkp; t];

