function z = MTV3Odbior();
%**************************************************************************
% Odczyt danych z robota i weryfikacja poprawnoci ramki
% KSIS: Pazderski i Michaek
% 18-02-2011
%**************************************************************************
% wejcie: brak
% wyjcie: z = 1 - odczyt prawidowy, z = 0 - ramka bdna
%**************************************************************************
global com buf
    z = 0;
    fs = com.BytesAvailable;    % liczba znakw w buforze odbionika
    r = fread(com, fs, 'uint8');   % czytaj bufor danych
    % sprawd rozmiar ramki
    if (r < 8)
        z = 1;
        return;
    end

    % dekodowanie ramki odpowiedzi (co najmniej jedna sekwencja 00 0A musi
    % by znaleziona)
    for i = 1:8
        if (r(i:i+2) == [0 255 170]')
            break;
        end
    end
    if i < 8     
        buf = r(i+3:fs);
        s = buf(3); % liczba danych
        crc = sum(buf(1:2+s));
        if (~(crc - buf(4+s) - buf(5+s) * 256)) 
            buf = buf(1:3+s);   % CRC jest poprawne
            z = 1;
        end
    end   
