function MTV3UstawOdometrie(q);
%**************************************************************************
% Ustawienie odometrii
% KSIS: Pazderski i Michaek
% 18-02-2011
%**************************************************************************
% wejcie: q = [th x y]'
% wyjcie: brak
%**************************************************************************

global com

    th = q(1); x = q(2); y = q(3); 
    
    if (th < 0)
        th = th + 2 * pi;
    end

    % konwersja do zapisu wewntrznego
    th = 953 / (2 * pi) * th;   
    th = float2int16(th);
    x = x * 1000 * 2^16;        
    x = float2int32(x);
    y = y * 1000 * 2^16;
    y = float2int32(y);

    % porzdkowanie bajtw
    % rozbicie na liczb 16-bitow
    th_0 = uint8(bitand(th,uint16(2^8-1)));
    th = bitshift(th,-8);
    th_1 = uint8(bitand(th,uint16(2^8-1)));

    % rozbicie na liczb 32-bitow
    x_0 = uint8(bitand(x,uint32(2^8-1)));
    x = bitshift(x,-8);
    x_1 = uint8(bitand(x,uint32(2^8-1)));
    x = bitshift(x,-8);
    x_2 = uint8(bitand(x,uint32(2^8-1)));
    x = bitshift(x,-8);
    x_3 = uint8(bitand(x,uint32(2^8-1)));

    y_0 = uint8(bitand(y,uint32(2^8-1)));
    y = bitshift(y,-8);
    y_1 = uint8(bitand(y,uint32(2^8-1)));
    y = bitshift(y,-8);
    y_2 = uint8(bitand(y,uint32(2^8-1)));
    y = bitshift(y,-8);
    y_3 = uint8(bitand(y,uint32(2^8-1)));
    
    % ustaw odometri
    bufor = [170 1 2 10 x_0 x_1 x_2 x_3 y_0 y_1 y_2 y_3 th_0 th_1];
    
    % obliczanie CRC
    crc = uint16(sum(bufor(1,2:size(bufor,2))));
    crc1 = uint8(bitshift(crc,-8));
    crc0 = uint8(bitand(crc,uint16(255)));
    bufor = [bufor crc0 crc1];

    % wyslij zapytanie
    fwrite(com, bufor, 'uint8');