//###########################################################################
//
// FILE:	DSP281x_CpuTimers.c
//
// TITLE:	DSP281x CPU 32-bit Timers Initialization & Support Functions.
//
// NOTES:   CpuTimer1 and CpuTimer2 are reserved for use with DSP BIOS and
//          other realtime operating systems.  
//
//          Do not use these two timers in your application if you ever plan
//          on integrating DSP-BIOS or another realtime OS. 
//
//          For this reason, the code to manipulate these two timers is
//          commented out and not used in these examples.
//           
//###########################################################################
//
//  Ver | dd mmm yyyy | Who  | Description of changes
// =====|=============|======|===============================================
//  1.00| 11 Sep 2003 | L.H  | Changes since previous version (v.58 Alpha)
//      |             |      | Removed some incorrect parameters in the timer
//      |             |      | setup that are not available on this device
//###########################################################################

#include "DSP281x_Device.h"     // DSP281x Headerfile Include File
#include "DSP281x_Examples.h"   // DSP281x Examples Include File
#include "PMxR_Etykiety.h"

struct CPUTIMER_VARS CpuTimer0;
struct CPUTIMER_VARS CpuTimer2;

//---------------------------------------------------------------------------
// InitCpuTimers: 
//---------------------------------------------------------------------------
// This function initializes all three CPU timers to a known state.
//
void MyInitCpuTimers(void)
{
    
    // CpuTimer0:
	CpuTimer0.RegsAddr = &CpuTimer0Regs;	// CPU Timer 0. Initialize address pointers to respective timer registers
	CpuTimer0Regs.PRD.all  = 0xFFFFFFFF;	// Initialize timer period to maximum
	
	CpuTimer0Regs.TPR.all  = 0;				// Initialize pre-scale counter to divide by 1 (SYSCLKOUT)
	CpuTimer0Regs.TPRH.all = 0;
	
	CpuTimer0Regs.TCR.bit.TSS = 1;			// Make sure timer is stopped
	CpuTimer0Regs.TCR.bit.TRB = 1;			// Reload all counter register with period value
	CpuTimer0.InterruptCount = 0;	        // Reset interrupt counters
	
		
	// CpuTimer2:
   	CpuTimer2.RegsAddr = &CpuTimer2Regs;	// CPU Timer 2. Initialize address pointers to respective timer registers
	CpuTimer2Regs.PRD.all  = 0xFFFFFFFF;	// Initialize timer period to maximum

	CpuTimer2Regs.TPR.all  = CpuT2PrescL;	// prescaler rwny 
	CpuTimer2Regs.TPRH.all = CpuT2PrescH;	// 				   okresowi PWM-a

	CpuTimer2Regs.TCR.bit.TSS = 1;			// Make sure timer is stopped    
	CpuTimer2Regs.TCR.bit.TRB = 1;			// Reload all counter register with period value
	//CpuTimer2Regs.TCR.bit.FREE = 1;			// timer free run             
	
	CpuTimer2.CPUFreqInMHz = 150;
	CpuTimer2.PeriodInUSec = T2Period_us;	// okres dla CpuTimer2 w [us] 
	CpuTimer2.InterruptCount = 0;			// Reset interrupt counters

}	
	
//---------------------------------------------------------------------------
// ConfigCpuTimer: 
//---------------------------------------------------------------------------
// This function initializes the selected timer to the period specified
// by the "Freq" and "Period" parameters. The "Freq" is entered as "MHz"
// and the period in "uSeconds". The timer is held in the stopped state
// after configuration.
//
void ConfigCpuTimer(struct CPUTIMER_VARS *Timer, float Freq, float Period)
{
	Uint32 	temp;
	
	// Initialize timer period:	
	Timer->CPUFreqInMHz = Freq;
	Timer->PeriodInUSec = Period;
	temp = (long) (Freq * Period);
	Timer->RegsAddr->PRD.all = temp;

	// Set pre-scale counter to divide by 1 (SYSCLKOUT):	
	Timer->RegsAddr->TPR.all  = 0;
	Timer->RegsAddr->TPRH.all  = 0;
	
	// Timer control register:
	Timer->RegsAddr->TCR.bit.TSS = 1;      // 1 = Stop timer, 0 = Start/Restart Timer 
	Timer->RegsAddr->TCR.bit.TRB = 1;      // 1 = reload timer
	
	Timer->RegsAddr->TCR.bit.SOFT = 0;		// test dla debug!!!
	Timer->RegsAddr->TCR.bit.FREE = 0;		// test dla debug!!!
	
	Timer->RegsAddr->TCR.bit.TIE = 1;      // 0 = Disable/ 1 = Enable Timer Interrupt
	Timer->InterruptCount = 0;				// Reset interrupt counter
}

//===========================================================================
// No more.
//===========================================================================
