//###########################################################################
//
// Etykiety
//
//###########################################################################

#ifndef MYLABELS_H
	#define MYLABELS_H
#endif


#define	Ch_A1		0x0100		//port A
#define	Ch_B1		0x0200		//port A
#define	Ch_I1		0x0400		//port A
#define	PWM_DSP1	0x0010		//port A
#define	PWM_I1		0x0004		//port A
#define	DIR_DSP1	0x0001		//port A
#define	DISABLE1	0x0020		//port A
#define	M01			0x0002		//port A
#define	M11			0x0008		//port A
#define	TF1			0x0040		//port B
#define	Vh1			0x0001		//wejcie analogowe ADCIN0

#define	Ch_A2		0x0100		//port B
#define	Ch_B2		0x0200		//port B
#define	Ch_I2		0x0400		//port B
#define	PWM_DSP2	0x0010		//port B
#define	PWM_I2		0x0004		//port B
#define	DIR_DSP2	0x0001		//port B
#define	DISABLE2	0x0020		//port B
#define	M02			0x0002		//port B
#define	M12			0x0008		//port B
#define	TF2			0x0080		//port B
#define	Vh2			0x0002		//wejcie analogowe ADCINA1



//*************************************
#define LED1		0x4000

#define	TRUE		1
#define	FALSE		0
#define	AZone		0
#define	BZone		1
#define	PI			3.14159265358979323846
#define	InvPI		(1.0/PI)
#define	TwoPI		2*PI
#define PI_2		(PI/2.0)


//*************************************
#define	EncoderRes	1000.0				// rozdzielczo enkodera w [impulsy/obrt]

#define	FullRes		(EncoderRes*4.0)	// pena rozdzielczo pomiaru pozycji silnika [impulsy/obrt] (kwadratura)
#define	PositionRes (1.0/FullRes)		// rozdzielczo pomiaru pozycji silnika [obroty/impuls] 
#define	PositionResR (TwoPI*PositionRes)// rozdzielczo pomiaru pozycji silnika [rad/impuls]
#define DeltaMotPos	33000.0				// przyrost pozycji silnika do kontroli przepenie

//*************************************
#define	PWMPeriod	0x0FFF		// rozdzielczo PWM: 12bit
#define	PWMDeltaI	0x03FF		// przyrost PWM dla wymuszenia prdowego
#define	T2Period	0xFFFF		// full dla QEP
#define	TCounter	0x0000	
#define	TCompare	0x7FFF	

#define	PWM0U		0x0000			// unipolarny PWM
#define	PWM50U		(PWMPeriod/2)
#define PWM100U		PWMPeriod

#define	PWM_50B		(PWMPeriod/4)	// bipolarny PWM
#define PWM_100B	0x0000
#define	PWM0B		(PWMPeriod/2)
#define	PWM50B		((3*PWMPeriod)/4)
#define PWM100B		PWMPeriod


//*************************************
#define	HSPresc150	0x0000			// prescaler dla zegara HSPCKL dajcy 150[MHz]
#define	LSPresc37_5 0x0002			// prescaler dla zegara LSPCKL dajcy 37.5[MHz]

#define	dT			0.001			// okres prbkowania systemu w [s]
#define	dT_us		(dT*1000000)	// okres prbkowania systemu w [us]
#define	Tp			dT				// okres pracy ptli regulacyjnych silnikw w [s]
#define	NumberOfdT	1				// wielokrotno okresw dT (prbkowania systemu)
#define dTg			(NumberOfdT*dT) // okres pracy generatorw sygnaw referencyjnych i sterownika VFO
#define invdTg		(1.0/dTg)		// odwrotno okresu pracy generatorw sygnaw referencyjnych
#define Tp_2		(Tp/2.0)
#define invTp		(1.0/Tp)

#define	CpuT2Presc	(PWMPeriod*4.0) // prescaler dla TimeraCpu2 (*4, bo taktowanie Timera1 jest dzielone przez 4)
#define	CpuT2PrescL	(char)(CpuT2Presc)
#define	CpuT2PrescH	(char)(CpuT2Presc/256)
#define T2Period_us	(float)(((PWMPeriod*4.0)/150.0)*4294967296.0)	// 4294967296 = 2^32

//*************************************
//dane RPM_max dla silnika Maxon A-max 32
#define	RPM_max1	4660.0				// maksymalna prdko silnika 1 w [obr/min]
#define RPS_max1	77.7				// maksymalna prdko silnika 1 w [obr/s]
#define	RPM_max2	4660.0				// maksymalna prdko silnika 2 w [obr/min]
#define RPS_max2	77.7				// maksymalna prdko silnika 2 w [obr/s]
#define Coeff_M1	(PositionRes/Tp)	// wspczynnik = 1/(N*4Tp) do obliczania prdkoci w [obr/s]
#define RadPS_max1	(TwoPI*RPS_max1)	// maksymalna prdko silnika 1 w [rad/s]
#define	IPS_max1	(RPS_max1*FullRes)	// maksymalna prdko silnika 1 w [imp/s]
#define RadPS_max2	(TwoPI*RPS_max2)	// maksymalna prdko silnika 2 w [rad/s]
#define	IPS_max2	(RPS_max2*FullRes)	// maksymalna prdko silnika 2 w [imp/s]

#define	PWMCLKFrec	(150000000.0/4.0)

#define	T			0.0472				// staa czasowa napdu
#define kf0aver		1.0/5.9				// rednia warto odwrotnoci wspczynnika wzmocnienia statycznego napdu

//*************************************
#define	fc			50.0				// czestotliwo odcicia w [Hz] dla filtru I-go rzdu (do estymacji prdkoci)
#define	fb1			(RPS_max1*FullRes)	// czstotliwo w [imp/s] dla maksymalnej prdkoci silnika 1
#define	fb2			(RPS_max2*FullRes)	// czstotliwo w [imp/s] dla maksymalnej prdkoci silnika 2
#define	Frac1_60	(1.0/60.0) 			// wspczynnik rwny 1/60
#define	_K1			(1.0/(fb1*Tp))		// wspczynnik rniczkowania K1 
#define	_K2			(1.0/(fb2*Tp))		// wspczynnik rniczkowania K2 

//*************************************
// wspczynniki dla regulatora ze sprzeniem od stanu:
#define ksi			0.8
#define	wn			20.0
#define k1			(wn*wn*T*kf0aver)
#define k2			((2.0*ksi*T*wn-1)*kf0aver)

// wspczynniki dla sprzenia wyprzedzajcego:
#define	Kff0		1.0					// wspczynnik wzmocnienia czci statycznej bloku F (sprzenie wyprzedzajce)
#define	Kff1		(T*kf0aver)			// wspczynnik wzmocnienia czci dynamicznej bloku F (sprzenie wyprzedzajce)
#define affp		0.160				// wspczynnik nachylenia cha-ki statycznej W-U silnika dla prdkoci dodatnich
#define bffp		0.331				// wyraz wolny cha-ki statycznej W-U silnika dla prdkoci dodatnich
#define affn		0.160				// wspczynnik nachylenia cha-ki statycznej W-U silnika dla prdkoci ujemnych
#define bffn		-0.338				// wyraz wolny cha-ki statycznej W-U silnika dla prdkoci ujemnych

//*************************************
#define	Umax1		(11.76)					// maksymalna warto sterowania na wyciu regulatora (odpowiada +12V)
#define	Umin1		(-11.76)					// minimalna warto sterowania na wyciu regulatora (odpowiada -12V)
#define Imax1		(2.0)					// maksymalna warto sterowania (prdu) na wyciu regulatora (odpowiada 3.1A)
#define Imin1		(-2.0)					// minimalna warto sterowania (prdu) na wyciu regulatora (odpowiada -3.1A)
#define	Uscaler1	(PWMPeriod/Umax1)		// wspczynnik skalujcy do realizacji sterowania napiciowego unipolarnego
#define	Bscaler1	(PWMPeriod/(2.0*Umax1))	// wspczynnik skalujcy do realizacji sterowania napiciowego bipolarnego
#define Iscaler1	(PWMDeltaI/Imax1)		// wspczynnik skalujcy do realizacji sterowania prdowego

#define	Umax2		(11.76)					// maksymalna warto sterowania na wyciu regulatora (odpowiada +12V)
#define	Umin2		(-11.76)					// minimalna warto sterowania na wyciu regulatora (odpowiada -12V)
#define Imax2		(2.0)					// maksymalna warto sterowania (prdu) na wyciu regulatora (odpowiada 3A)
#define Imin2		(-2.0)					// minimalna warto sterowania (prdu) na wyciu regulatora (odpowiada -3A)
#define	Uscaler2	(PWMPeriod/Umax2)		// wspczynnik skalujcy do realizacji sterowania napiciowego unipolarnego
#define	Bscaler2	(PWMPeriod/(2.0*Umax2))	// wspczynnik skalujcy do realizacji sterowania napiciowego bipolarnego
#define Iscaler2	(PWMDeltaI/Imax2)		// wspczynnik skalujcy do realizacji sterowania prdowego
