//###########################################################################
//
// Funkcje - plik nagwkowy: "PMxR_Funkcje.h"
//
//###########################################################################

#ifndef DSP281x_DEVICE_H
	#include "DSP281x_Device.h"
#endif

#ifndef MYLABELS_H
	#include "PMxR_Etykiety.h"
#endif

#define GLOBAL_Q 14

#ifndef __IQMATHLIB_H_INCLUDED__
	#include "IQmathLib.h"
#endif

#ifndef MYDATA_H
	#include "PMxR_StrukturyDanych.h"
#endif

//***************************************************************************************
void MyDataInit(void)
{
		
	STATUS.bit.ControlMode = 0;
	STATUS.bit.GenType = 0;
	STATUS.bit.ABzone = AZone;
	STATUS.bit.Fslope = FALSE;
		
	//*******************************************	
	Generator1.A = _IQ(4.5);
	Generator1.F = _IQ(0.25);
	Generator2.A = _IQ(4.5);
	Generator2.F = _IQ(0.25);
	
	Motor1.DeltaPos = (int32)(DeltaMotPos);
	Motor2.DeltaPos = (int32)(DeltaMotPos);
	Motor1.K = _IQ(_K1);
	Motor2.K = _IQ(_K2);
	Motor1.RPS_max = _IQ14(RPS_max1);
	Motor2.RPS_max = _IQ14(RPS_max2);
	Motor1.RadPS_max = _IQ14(RadPS_max1);
	Motor2.RadPS_max = _IQ21(RadPS_max2);
	Motor1.IPS_max = _IQ13(IPS_max1);
	Motor2.IPS_max = _IQ13(IPS_max2);

	//**** inicjalizacje regulatorw stanu ****	
	Regulator1.K1 = _IQ21(k1);
	Regulator1.K2 = _IQ21(k2);
	Regulator1.Kf0 = _IQ21(Kff0);
	Regulator1.Kf1 = _IQ21(Kff1);
	
	Regulator2.K1 = _IQ21(k1);
	Regulator2.K2 = _IQ21(k2);
	Regulator2.Kf0 = _IQ21(Kff0);
	Regulator2.Kf1 = _IQ21(Kff1);
	
	//**** inicjowanie wspczynnikw skalujcych ****
	CSignals1.SscalerUU = _IQ19(Uscaler1);
	CSignals1.SscalerUB = _IQ19(Bscaler1);
	CSignals1.SscalerI = _IQ19(Iscaler1);
	CSignals1.C_out_max = _IQ19(Umax1);
	CSignals1.C_out_min = _IQ19(Umin1);
	
	CSignals2.SscalerUU = _IQ19(Uscaler2);
	CSignals2.SscalerUB = _IQ19(Bscaler2);
	CSignals2.SscalerI = _IQ19(Iscaler2);
	CSignals2.C_out_max = _IQ19(Umax2);
	CSignals2.C_out_min = _IQ19(Umin2);
			
	NumberOfSamples = 5;			// co 'NumberOfSamples' prbka bdzie zapisywana w celu wizalizacji
	DataCount = NumberOfSamples;	
	WisDataSize = 1000;				// liczba buforowanych prbek pomidzy przesyami do wizualizacji
}


//***************************************************************************************
// generator sygnaw referencyjnych niskiego poziomu (poziom napdw):
//***************************************************************************************
void MyLowLevelRefGenerator(void)
{
	_iq	tmp, tmp1, tmp2, Omega1, Omega2;
	
	GenTime += dTgIQ; 								// bieca warto czasu dla generatorw
	
	Omega1 = _IQmpy(TwoPIIQ,Generator1.F);
	Omega2 = _IQmpy(TwoPIIQ,Generator2.F);

	// generator sygnau sinusoidalnego - silnik 1:
	tmp1 = _IQmpy(GenTime,Omega1);
	tmp2 = _IQmpy(Generator1.A,_IQsin(tmp1));
	Generator1.GenOut = _IQtoIQ21(tmp2);	
	
	tmp = _IQmpy(Generator1.A,Omega1);
	tmp2 = _IQmpy(tmp,_IQcos(tmp1));
	Generator1.GenOut_p = _IQtoIQ21(tmp2);
	
	tmp2 = -_IQmpy(_IQmpy(tmp,Omega1),_IQsin(tmp1));
	Generator1.GenOut_pp = _IQtoIQ21(tmp2);		
	
	// generator sygnau prostoktnego - silnik 1:
	if (STATUS.bit.GenType==1)
	{
		if (Generator1.GenOut>=0)
		{	
			Generator1.GenOut = _IQtoIQ21(Generator1.A);
			Generator1.GenOut_p = 0;
			Generator1.GenOut_pp = 0;
		}
		else
		{
			Generator1.GenOut = _IQtoIQ21(-Generator1.A);
			Generator1.GenOut_p = 0;
			Generator1.GenOut_pp = 0;
		}
	}
	
	// generator sygnau staego - silnik 1:
	if (STATUS.bit.GenType==3)
	{
		Generator1.GenOut = _IQtoIQ21(Generator1.A);
		Generator1.GenOut_p = 0;
		Generator1.GenOut_pp = 0;
	}	
	
	//*********************************************
	// generator sygnau sinusoidalnego - silnik 2:
	tmp1 = _IQmpy(GenTime,Omega2);
	tmp2 = _IQmpy(Generator2.A,_IQsin(tmp1));
	Generator2.GenOut = _IQtoIQ21(tmp2);	
	
	tmp = _IQmpy(Generator2.A,Omega2);
	tmp2 = _IQmpy(tmp,_IQcos(tmp1));
	Generator2.GenOut_p = _IQtoIQ21(tmp2);
	
	tmp2 = -_IQmpy(_IQmpy(tmp,Omega2),_IQsin(tmp1));
	Generator2.GenOut_pp = _IQtoIQ21(tmp2);		
	
	// generator sygnau prostoktnego - silnik 2:
	if (STATUS.bit.GenType==1)
	{
		if (Generator2.GenOut>=0)
		{	
			Generator2.GenOut = _IQtoIQ21(Generator2.A);
			Generator2.GenOut_p = 0;
			Generator2.GenOut_pp = 0;
		}
		else
		{
			Generator2.GenOut = _IQtoIQ21(-Generator2.A);
			Generator2.GenOut_p = 0;
			Generator2.GenOut_pp = 0;
		}
	}
		
	// generator sygnau staego - silnik 2:
	if (STATUS.bit.GenType==3)
	{
		Generator2.GenOut = _IQtoIQ21(Generator2.A);
		Generator2.GenOut_p = 0;
		Generator2.GenOut_pp = 0;
	}	
}

//***************************************************************************************
// skalowanie sygnau sterujcego:
//***************************************************************************************
void MyControlRealization(_iq21 U_ToScale1, _iq21 U_ToScale2)
{
	_iq		tmp1, tmp2;
	Uint16  tmp116, tmp216;
	
	tmp1 = _IQ21toIQ(U_ToScale1);
	tmp1 = _IQtoIQ19(tmp1);
	tmp2 = _IQ21toIQ(U_ToScale2);
	tmp2 = _IQtoIQ19(tmp2);

	if (STATUS.bit.ControlMode==0)							// sterowanie napiciowe unipolarne
	{	
		tmp1 = _IQ19rmpy(tmp1,CSignals1.SscalerUU);	
							
		if (U_ToScale1>=0)		
		{
			GpioDataRegs.GPASET.all = DIR_DSP1;
			EvaRegs.CMPR3 = (int16)(_IQ19int(tmp1));
		}
		else
		{
			GpioDataRegs.GPACLEAR.all = DIR_DSP1;
			EvaRegs.CMPR3 = (int16)(_IQ19int(-tmp1));
		}
		//*******************************************
		tmp2 = _IQ19rmpy(tmp2,CSignals2.SscalerUU);

		if (U_ToScale2>=0)		
		{
			GpioDataRegs.GPBSET.all = DIR_DSP2;
			EvbRegs.CMPR6 = (int16)(_IQ19int(tmp2));
		}
		else
		{
			GpioDataRegs.GPBCLEAR.all = DIR_DSP2;
			EvbRegs.CMPR6 = (int16)(_IQ19int(-tmp2));
		}
	}
	else if (STATUS.bit.ControlMode==1)						// sterowanie napiciowe bipolarne
	{
		tmp1 = _IQ19rmpy(tmp1,CSignals1.SscalerUB);
		tmp116 = (Uint16)(_IQ19int(PWM0BIQ19 + tmp1));
		EvaRegs.CMPR3 = tmp116;
		//********************************************
		tmp2 = _IQ19rmpy(tmp2,CSignals2.SscalerUB);
		tmp216 = (Uint16)(_IQ19int(PWM0BIQ19 + tmp2));
		EvbRegs.CMPR6 = tmp216;
	}
	else													// sterowanie prdowe
	{
		tmp1 = _IQ19rmpy(tmp1,CSignals1.SscalerI);	
		tmp116 = (int16)(_IQ19int(PWM0BIQ19 - tmp1));	// uwaga: konieczna zmiana znaku!
		EvaRegs.CMPR2 = tmp116;
		//*******************************************
		tmp2 = _IQ19rmpy(tmp2,CSignals2.SscalerI);
		tmp216 = (int16)(_IQ19int(PWM0BIQ19 + tmp2));
		EvbRegs.CMPR5 = tmp216;
	}
}

//***************************************************************************************
// obliczanie pozycji silnika w iq11:
//***************************************************************************************
void MyComputePositionIQ11(MotorStruct *Motor)
{
	_iq11 	Temp;
	int32	delta;

	//**** kontrola przepenie ****
	delta = Motor->ImpulseOffset - Motor->ImpulseOffset_1;

	if (delta > (Motor->DeltaPos))
	{
		Motor->NumberOfOverflows--;
	}
	else if (delta < (-Motor->DeltaPos))
	{
		Motor->NumberOfOverflows++;
	}
	//**** koniec kontroli przepenie ****

	Motor->PositionIMP = (Motor->NumberOfOverflows*((Uint32)(T2Period)+1)) + Motor->ImpulseOffset;
	Temp = _IQ11(Motor->PositionIMP);
	Motor->PositionREV = _IQ11div(Temp,FullResIQ11);
		
	Motor->ImpulseOffset_1 = Motor->ImpulseOffset;
}

//***************************************************************************************
// obliczanie prdkoci silnika w iq14 metod pomiaru drogi: 
//***************************************************************************************
void  MyComputeVelocityIMP(MotorStruct *Motor)
{
	_iq		tmp1, Temp;
		
	Temp = Motor->PositionIMP - Motor->Position_old;
	Temp = _IQ(Temp);
	Motor->Position_old = Motor->PositionIMP;
	Motor->VelocityQEPREV = _IQmpy(CoeffM1,Temp);	

	tmp1 = _IQmpy(Motor->K,Temp);				
	// ograniczenie wartoci do zakresu [-1,1]:
	if (tmp1>_IQ(1.0))
		tmp1 = _IQ(1.0);
	else if (tmp1<_IQ(-1.0))
		tmp1 = _IQ(-1.0);
		
	Motor->VelocityQEPNor =  tmp1;
	Motor->VelocityQEPRAD = _IQmpy(TwoPIIQ,Motor->VelocityQEPREV);	
}

//***************************************************************************************
// wyczenie wzmacniacza mocy napdw:
//***************************************************************************************
void MyMotorSTOP(void)
{
	GpioDataRegs.GPASET.all = DISABLE1;			// zablokowanie kocwki mocy 1
	GpioDataRegs.GPBSET.all = DISABLE2;			// zablokowanie kocwki mocy 2
	MyControlRealization(0,0);  				// zerowanie sygnau sterujcego
}

//***************************************************************************************
// zaczenie wzmacniacza mocy napdw:
//***************************************************************************************
void MyMotorSTART(void)
{
	MyControlRealization(0,0);  				// zerowanie sygnau sterujcego
	GpioDataRegs.GPACLEAR.all = DISABLE1;		// odblokowanie kocwki mocy 1
	GpioDataRegs.GPBCLEAR.all = DISABLE2;		// odblokowanie kocwki mocy 2
}









//***************************************************************************************
// This function initializes the clocks to the peripheral modules.
// First the high and low clock prescalers are set
// Second the clocks are enabled to each peripheral.
// To reduce power, leave clocks to unused peripherals disabled
// Note: If a peripherals clock is not enabled then you cannot 
// read or write to the registers for that peripheral 

void MyInitPeripheralClocks(void)
{
	EALLOW;
// HISPCP/LOSPCP prescale register settings (after reset HSPCLK=150/2 MHz)
	SysCtrlRegs.HISPCP.all = HSPresc150;	//HSPCLK = 150 MHz
	SysCtrlRegs.LOSPCP.all = LSPresc37_5;	//LSPCLK = 150/4=37.5 MHz
   	
// Peripheral clock enables set for the selected peripherals.   
	SysCtrlRegs.PCLKCR.bit.EVAENCLK=1;
	SysCtrlRegs.PCLKCR.bit.EVBENCLK=1;
	SysCtrlRegs.PCLKCR.bit.SCIAENCLK=1;
	SysCtrlRegs.PCLKCR.bit.SCIBENCLK=1;
	SysCtrlRegs.PCLKCR.bit.MCBSPENCLK=1;
	SysCtrlRegs.PCLKCR.bit.SPIENCLK=1;
	SysCtrlRegs.PCLKCR.bit.ECANENCLK=1;
	SysCtrlRegs.PCLKCR.bit.ADCENCLK=1;
	EDIS;
}

//***************************************************************************************
void MyInitGpio(void)
{
	Uint16 var1, var2, var3;
	Uint16 AMux, ADIR, BMux, BDIR;
	
	AMux = Ch_A1 | Ch_B1 | Ch_I1 | PWM_DSP1 | PWM_I1;			//maska podczenia do peryferiw
	ADIR = PWM_DSP1 | PWM_I1 | DIR_DSP1 | DISABLE1 | M01 | M11;	//maska kierunku dla pinw wyjciowych
	        
    BMux = Ch_A2 | Ch_B2 | Ch_I2 | PWM_DSP2 | PWM_I2;			//maska podczenia do peryferiw
	BDIR = PWM_DSP2 | PWM_I2 | DIR_DSP2 | DISABLE2 | M02 | M12;	//maska kierunku dla pinw wyjciowych
	        
    var1 = 0x0000;		// sets GPIO Muxs as I/Os
    var2 = 0xFFFF;		// sets GPIO DIR as outputs
    var3 = 0x0000;		// sets the Input qualifier values
   
    EALLOW;
	 
	GpioMuxRegs.GPAMUX.all = AMux;
	GpioMuxRegs.GPBMUX.all = BMux;   
    GpioMuxRegs.GPDMUX.all = var1;
    GpioMuxRegs.GPEMUX.all = var1;		 
	
	GpioMuxRegs.GPEMUX.bit.XINT1_XBIO_GPIOE0 = 1;	//podczenie pinu do sygnau przerwania$
	
    GpioMuxRegs.GPFMUX.all = var1; 
    GpioMuxRegs.GPGMUX.all = var1;
										
    GpioMuxRegs.GPADIR.all = ADIR;		 
    GpioMuxRegs.GPBDIR.all = BDIR; 		  
    GpioMuxRegs.GPDDIR.all = var2;
    GpioMuxRegs.GPEDIR.all = var2;
    
    GpioMuxRegs.GPEDIR.bit.GPIOE0 = 0;				//pin XINT1 jako wejcie (przerwaniowe)$
    		
    GpioMuxRegs.GPFDIR.all = var2; 
    GpioMuxRegs.GPGDIR.all = var2;

    GpioMuxRegs.GPAQUAL.bit.QUALPRD = 0;//var3; 	 
    GpioMuxRegs.GPBQUAL.bit.QUALPRD = 0;//var3;   
    GpioMuxRegs.GPDQUAL.all = var3;
    GpioMuxRegs.GPEQUAL.all = var3;
    
    
    GpioDataRegs.GPADAT.all = 0xFFFF;		// stan domylny: wszystkie piny wyjciowe = 1
    GpioDataRegs.GPBDAT.all = 0xFFFF;
    GpioDataRegs.GPDDAT.all = 0xFFFF;
    GpioDataRegs.GPEDAT.all = 0xFFFF;
    GpioDataRegs.GPFDAT.all = 0xFFFF;
    GpioDataRegs.GPGDAT.all = 0xFFFF;
    
    EDIS;  
}

//***************************************************************************************
void MyInitEVA(void)
{
   	// Initalize Timer1 
	EvaRegs.T1PR = PWMPeriod;  	   		// Timer1 period
	EvaRegs.T1CMPR = 0;
	EvaRegs.T1CNT = TCounter;  			// Timer1 counter
	EvaRegs.T1CON.bit.TMODE = 2;		// TMODE = continuous up
	EvaRegs.T1CON.bit.TPS = 2;			// T1CLK=HSPCLK/4 (150/4 [MHz])
	EvaRegs.T1CON.bit.FREE =1;			// 'free run' dla Timera 1 (debugger nie zatrzymuje Timera1)
								
	// Initalize Timer2 
	EvaRegs.T2PR = T2Period;     		// Timer2 period - full dla QEP
	EvaRegs.T2CNT = TCounter;	  		// Timer2 counter
	EvaRegs.T2CON.bit.TMODE = 3;		// TMODE = directional up/down 
	EvaRegs.T2CON.bit.TCLKS10 = 3;		// taktowanie Timera z QEP
	EvaRegs.T2CON.bit.SOFT = 1; 		// 'free run' dla Timera 2 (debugger nie zatrzymuje Timera2)
	EvaRegs.T2CON.bit.FREE = 1;

	// Enable compare for PWM 3,5
	EvaRegs.CMPR2 = 0;					// Domylnie 0% wypenienia dla pinu PWM_I1
	EvaRegs.CMPR3 = 0;					// Domylnie 0% wypenienia dla pinu PWM_DSP1
	
    EvaRegs.ACTRA.bit.CMP3ACT = 2;		// Active High na pinie PWM_I1
    EvaRegs.ACTRA.bit.CMP5ACT = 1;		// Active Low na pinie PWM_DSP1
    
    EvaRegs.COMCONA.bit.FCMP2OE = 1;	// odblokowanie wyj bloku FullCompare2
	EvaRegs.COMCONA.bit.FCMP3OE = 1;	// odblokowanie wyj bloku FullCompare3
	EvaRegs.COMCONA.bit.FCOMPOE = 1;	// odblokowanie wyj blokw FullCompare
	EvaRegs.COMCONA.bit.CENABLE = 1;	// odblokowanie operacji Compare
	
	// Odblokowanie zgoszenia przerwa
	/*EvaRegs.EVAIMRB.bit.T2PINT = 1;		// odblokowanie przerwania od T2P
	EvaRegs.EVAIFRB.bit.T2PINT = 1;		// skasowanie ewentualnego zgoszenia przerwania od T2P
	
	EvaRegs.EVAIMRB.bit.T2CINT = 1;		// odblokowanie przerwania od T2C
	EvaRegs.EVAIFRB.bit.T2CINT = 1;		// skasowanie ewentualnego zgoszenia przerwania od T2C
	
	EvaRegs.EVAIMRB.bit.T2UFINT = 1;	// odblokowanie przerwania od T2UF
	EvaRegs.EVAIFRB.bit.T2UFINT = 1;	// skasowanie ewentualnego zgoszenia przerwania od T2UF
	
	EvaRegs.EVAIMRB.bit.T2OFINT = 1;	// odblokowanie przerwania od T2OF
	EvaRegs.EVAIFRB.bit.T2OFINT = 1;	// skasowanie ewentualnego zgoszenia przerwania od T2OF
	*/
} 

//***************************************************************************************
void MyInitEVB(void)
{
	// Initalize Timer3 
	EvbRegs.T3PR = PWMPeriod;  	   		// Timer3 period
	EvbRegs.T3CMPR = 0;
	EvbRegs.T3CNT = TCounter;  			// Timer1 counter
	EvbRegs.T3CON.bit.TMODE = 2;		// TMODE = continuous up
	EvbRegs.T3CON.bit.TPS = 2;			// T3CLK=HSPCLK/4 (150/4 [MHz])
	EvbRegs.T3CON.bit.FREE =1;			// 'free run' dla Timera 3 (debugger nie zatrzymuje Timera3)
								
	// Initalize Timer4 
	EvbRegs.T4PR = T2Period;     		// Timer4 period - full dla QEP
	EvbRegs.T4CNT = TCounter;	  		// Timer4 counter
	EvbRegs.T4CON.bit.TMODE = 3;		// TMODE = directional up/down 
	EvbRegs.T4CON.bit.TCLKS10 = 3;		// taktowanie Timera z QEP
	EvbRegs.T4CON.bit.SOFT = 1; 		// debugger nie 
	EvbRegs.T4CON.bit.FREE = 1;			//		zatrzymuje Timera 4

	// Enable compare for PWM 9,11
	EvbRegs.CMPR5 = 0;					// Domylnie 0% wypenienia dla pinu PWM_I2
	EvbRegs.CMPR6 = 0;					// Domylnie 0% wypenienia dla pinu PWM_DSP2
	
    EvbRegs.ACTRB.bit.CMP9ACT = 2;		// Active High na pinie PWM_I2
    EvbRegs.ACTRB.bit.CMP11ACT = 1;		// Active Low na pinie PWM_DSP2
    
    EvbRegs.COMCONB.bit.FCMP5OE = 1;	// odblokowanie wyj bloku FullCompare5
	EvbRegs.COMCONB.bit.FCMP6OE = 1;	// odblokowanie wyj bloku FullCompare6
	EvbRegs.COMCONB.bit.FCOMPOE = 1;	// odblokowanie wyj blokw FullCompare
	EvbRegs.COMCONB.bit.CENABLE = 1;	// odblokowanie operacji Compare
	
	// Odblokowanie zgoszenia przerwa
	/*EvbRegs.EVBIMRB.bit.T4PINT = 1;		// odblokowanie przerwania od T4P
	EvbRegs.EVBIFRB.bit.T4PINT = 1;		// skasowanie ewentualnego zgoszenia przerwania od T4P
	*/
}
