#include "DSP281x_Device.h"     // DSP281x Headerfile Include File
#include "DSP281x_Examples.h"   // DSP281x Examples Include File
#include "DSP281x_XIntrupt.h"
#include "PMxR_Funkcje.h"		// plik naglowkowy funkcji uzytkowych
#include "PMxR_Etykiety.h"		// plik z etykietami
	
#pragma DATA_SECTION(dane1_5,"bufor1");
#pragma DATA_SECTION(dane2_5,"bufor2");

// stae IQ *************************************
const	_iq	FullResIQ9 = _IQ9(FullRes);
const	_iq	FullResIQ11 = _IQ11(FullRes);
const	_iq	TwoPIIQ = _IQ(TwoPI);
const	_iq	TwoPIIQ21 = _IQ21(TwoPI);
const	_iq	PI_2IQ21 = _IQ21(PI_2);
const	_iq	PIIQ21 = _IQ21(PI);
const	_iq	InvPIIQ21 = _IQ21(InvPI);
const	_iq	dTgIQ = _IQ(dTg);
const	_iq	dTgIQ21 = _IQ21(dTg);
const	_iq	PWM0BIQ19 = _IQ19(PWM0B);

const   _iq	invdTgIQ21 = _IQ21(invdTg);
const   _iq	invTpIQ = _IQ(invTp);
const	_iq	TpIQ21 = _IQ21(Tp);
const	_iq	TpIQ14 = _IQ14(Tp);
const	_iq	Tp_2IQ21 = _IQ21(Tp_2);

const	_iq	Affp = _IQ21(affp);
const	_iq	Bffp = _IQ21(bffp);
const	_iq	Affn = _IQ21(affn);
const	_iq	Bffn = _IQ21(bffn);

const	_iq	CoeffM1 = _IQ(Coeff_M1);

// zmienne globalne *****************************

_iq				 GenTime = 0;

MotorStruct		 Motor1 = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
MotorStruct		 Motor2 = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
GeneratorStruct	 Generator1 = {0,0,0,0,0};
GeneratorStruct	 Generator2 = {0,0,0,0,0};
StateRegStruct	 Regulator1 = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
StateRegStruct	 Regulator2 = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
ConSigStruct	 CSignals1 = {0,0,0,0,0};
ConSigStruct	 CSignals2 = {0,0,0,0,0};

STATUS_BITS		 STATUS;

float 			 dane1_5[50000];
float 			 dane2_5[50000];

Uint16			 j=0;				// biecy licznik prbek zapisywanych do bufora (do wizualizacji)
Uint16			 NumberOfSamples=1;	// wskazuje co ktra prbka bdzie zapisana do bufora (do wizualizacji)
Uint16			 DataCount=0;		// licznik prbek pomijanych (nie zapisywanych)
Uint16			 WisDataSize=1000;	// cakowita liczba prbek do zapisu w buforze (do wizualizacji)

//***********************************************


void main(void)
{

// Step 1. Initialize System Control: PLL, WatchDog, enable Peripheral Clocks (DSP281x_SysCtrl.c)
	DisableDog();				// Disable the watchdog     
   	InitPll(0xA);				// Initialize the PLLCR to 0xA
	MyInitPeripheralClocks();	// Initialize the peripheral clocks
	InitXintf();				// Inicjalizacja interfejsu pamici zewntrznej
			
// Step 2. Initalize GPIO: 
	MyInitGpio();    


// Step 3. Clear all interrupts and initialize PIE vector table (DSP281x_PieCtrl.c,DSP281x_DefaultIsr.c,DSP281x_PieVect.c):
	DINT;		
	InitPieCtrl();
	IER = 0x0000;				// Disable CPU interrupts and clear all CPU interrupt flags
	IFR = 0x0000;
	InitPieVectTable();
	EALLOW;  
	PieVectTable.TINT0 = &MyCpu_timer0_isr;
	
	PieVectTable.T2PINT = &MyTimer2Period_isr;
	PieVectTable.T2CINT = &MyTimer2Compare_isr;
	PieVectTable.T2UFINT = &MyTimer2Underflow_isr;
	PieVectTable.T2OFINT = &MyTimer2Overflow_isr;

	PieVectTable.T4PINT = &MyTimer4Period_isr;
	PieVectTable.T4CINT = &MyTimer4Compare_isr;
	PieVectTable.T4UFINT = &MyTimer4Underflow_isr;
	PieVectTable.T4OFINT = &MyTimer4Overflow_isr;

	PieVectTable.XINT1 = &MyEXternalVSign_isr;	//podpicie wektora obsugi przerwania od pinu XINT1$ 
	XIntruptRegs.XINT1CR.bit.POLARITY = 1;		//polaryzacja 'rising edge' dla pinu XINT1$
	//XIntruptRegs.XINT1CR.bit.ENABLE = 1;		//odblokowanie przerwania od pinu XINT1$

	EDIS;    


// Step 4. Initialize Device Peripherals (DSP281x_InitPeripherals.c):
      
   	MyInitCpuTimers();		// Initialize CPU Timers To default State
	ConfigCpuTimer(&CpuTimer0, 150, dT_us); // Configure CPU-Timer 0 to interrupt every dT_us/1000000 seconds: 150MHz CPU Freq, dT Period (in uSeconds)
	MyInitEVA();			// Initialize Event Manager A Peripheral
	MyInitEVB();			// Initialize Event Manager B Peripheral
	

// Step 5. Enable PIE interrupts:
	PieCtrlRegs.PIEIER1.all = (M_INT4 | M_INT7);			// Enable XINT1 and TINT0 in the PIE: Group 1 interrupt 4 and 7$
	PieCtrlRegs.PIEIER3.all = (M_INT1|M_INT2|M_INT3|M_INT4);// Enable T2PINT, T2CINT, T2UFINT, T2OFINT in the PIE: Group 3 interrupt 1,2,3,4 
	PieCtrlRegs.PIEIER5.all = (M_INT1|M_INT2|M_INT3|M_INT4);// Enable T4PINT, T4CINT, T4UFINT, T4OFINT in the PIE: Group 5 interrupt 1,2,3,4
	IER |= (M_INT1 | M_INT2 | M_INT3 | M_INT4 | M_INT5);	// Enable CPU INT1, INT2, INT3, INT4, INT5


// ******** Inicjalizacje kocowe *****

	MyDataInit();
	
	GpioDataRegs.GPASET.all = DIR_DSP1;			// wymuszenie kierunku ruchu silnika 1 w prawo (prawo - patrzc na silnik od przodu)
		
	if (STATUS.bit.ControlMode==0)
	{
		GpioDataRegs.GPACLEAR.all = M01 | M11;	// tryb unipolarny napiciowy dla silnika 1
		GpioDataRegs.GPBCLEAR.all = M02 | M12;	// tryb unipolarny napiciowy dla silnika 2
		
		EvaRegs.CMPR2 = PWM100U;				// podanie 100% wypenienia dla pinu PWM_I1
		EvaRegs.CMPR3 = PWM0U;					// podanie  0% wypenienia dla pinu PWM_DSP1
		EvbRegs.CMPR5 = PWM100U;				// podanie 100% wypenienia dla pinu PWM_I2
		EvbRegs.CMPR6 = PWM0U;					// podanie  0% wypenienia dla pinu PWM_DSP2
		
		CSignals1.C_out_max = _IQ21(Umax1);
		CSignals1.C_out_min = _IQ21(Umin1);		
		CSignals2.C_out_max = _IQ21(Umax2);
		CSignals2.C_out_min = _IQ21(Umin2);		
	}
	else if (STATUS.bit.ControlMode==1)
	{
		GpioDataRegs.GPACLEAR.all = M01;
		GpioDataRegs.GPASET.all = M11; 			// tryb bipolarny napiciowy dla silnika 1
		GpioDataRegs.GPBCLEAR.all = M02;	
		GpioDataRegs.GPBSET.all = M12;			// tryb bipolarny napiciowy dla silnika 2
		
		EvaRegs.CMPR2 = PWM100U;				// podanie 100% wypenienia dla pinu PWM_I1
		EvaRegs.CMPR3 = PWM0B;					// podanie 50% wypenienia dla pinu PWM_DSP1
		EvbRegs.CMPR5 = PWM100U;				// podanie 100% wypenienia dla pinu PWM_I2
		EvbRegs.CMPR6 = PWM0B;					// podanie 50% wypenienia dla pinu PWM_DSP2
	
		CSignals1.C_out_max = _IQ21(Umax1);
		CSignals1.C_out_min = _IQ21(Umin1);
		CSignals2.C_out_max = _IQ21(Umax2);
		CSignals2.C_out_min = _IQ21(Umin2);
	}
	else
	{
		GpioDataRegs.GPASET.all = M01;
		GpioDataRegs.GPACLEAR.all = M11;		// tryb prdowy dla silnika 1
		GpioDataRegs.GPBSET.all = M02;	
		GpioDataRegs.GPBCLEAR.all = M12;		// tryb prdowy dla silnika 2
		
		EvaRegs.CMPR2 = PWM0B;					// podanie  0% wypenienia dla pinu PWM_I1
		EvaRegs.CMPR3 = PWM100U;				
		EvbRegs.CMPR5 = PWM0B;					// podanie  0% wypenienia dla pinu PWM_I2
		EvbRegs.CMPR6 = PWM100U;				
		
		CSignals1.C_out_max = _IQ21(Imax1);
		CSignals1.C_out_min = _IQ21(Imin1);
		CSignals2.C_out_max = _IQ21(Imax2);
		CSignals2.C_out_min = _IQ21(Imin2);
	}
   

// ******** Start po inicjalizacji ********

	EvaRegs.T1CON.bit.TENABLE = 1;			// uruchomienie Timera 1 jako generatora PWM
	EvbRegs.T3CON.bit.TENABLE = 1;			// uruchomienie Timera 3 jako generatora PWM
	EvaRegs.T2CON.bit.TENABLE = 1;			// uruchomienie Timera 2 jako QEP counter
    EvbRegs.T4CON.bit.TENABLE = 1;			// uruchomienie Timera 4 jako QEP counter
    
    StartCpuTimer0();						// uruchomienie synchronizacji systemu (okres dT)

	GpioDataRegs.GPACLEAR.all = DISABLE1;	// odblokowanie kocwki mocy 1
    GpioDataRegs.GPBCLEAR.all = DISABLE2;	// odblokowanie kocwki mocy 2
           
   	EINT;   								// Enable Global interrupt INTM
	ERTM;   								// Enable Global realtime interrupt DBGM


// ******** Ptla nieskoczona ************
	for(;;);								// IDLE loop
} 


