//###########################################################################
//
// Funkcje obsugi przerwa - plik nagwkowy : "PMxR_Funkcje.h"
//
//###########################################################################

#ifndef DSP281x_DEVICE_H
	#include "DSP281x_Device.h"
#endif

#ifndef DSP281x_XIntrupt_H
	#include "DSP281x_XIntrupt.h"
#endif

#ifndef MYLABELS_H
	#include "PMxR_Etykiety.h"
#endif

#ifndef MYFUNCTIONS_H
	#include "PMxR_Funkcje.h"
#endif


//***************************************************************************************
interrupt void MyCpu_timer0_isr(void)
{	
	extern float dane1_5[50000];	// bufor danych do wizualizacji
	extern float dane2_5[50000];	// bufor danych do wizualizacji
	
	// **** niezwoczne przygotowanie danych do liczenia prdkoci i pozycji:
	Motor1.ImpulseOffset = (int32)(EvaRegs.T2CNT);	// zatrzanicie biecej zawartoci licznika T2
	Motor2.ImpulseOffset = (int32)(EvbRegs.T4CNT);	// zatrzanicie biecej zawartoci licznika T4
	//**** koniec przygotowania danych **************************************
		
	CpuTimer0.InterruptCount++;			// inkrementacja bezwzgldnego licznika okresw pracy systemu
	
	//************************************************	
	//**** TU OBLICZENIA GENERATORA I POMIARY !!! ****
	//************************************************	

									
	//**** TU OBLICZENIA REGULATORA !!! **************
	//************************************************
	
	
	// fizyczna realizacja sygnau sterujcego:	
	MyControlRealization(Regulator1.C_out,Regulator2.C_out);  	
					
	// adowanie danych do wizualizacji co 'NumberOfSamples' prbek:
	if (DataCount==NumberOfSamples)
	{
		DataCount = 0;
		if (j>(WisDataSize-1))
		{
			MyMotorSTOP();	// zatrzymanie napdw w celu bezpiecznego przesyu danych do wizualizacji
			j=0;
			MyMotorSTART();	// ponowne uruchomienie napdw
		}
		dane1_5[j] 		  = _IQ11toF(Motor1.PositionREV);
		dane1_5[j+10000]  = _IQ21toF(Generator1.GenOut);
		dane1_5[j+20000]  = _IQ21toF(Regulator1.C_out);
		dane1_5[j+30000]  = _IQ21toF(Regulator1.e1);
		dane1_5[j+40000]  = _IQtoF(Motor1.VelocityQEPREV);
			
		dane2_5[j] 		  = 0.0;
		dane2_5[j+10000]  = 0.0;
		dane2_5[j+20000]  = 0.0;
		dane2_5[j+30000]  = 0.0;
		dane2_5[j+40000]  = 0.0;
				
		j++;
	}
	DataCount++;
	//******************************************************************
	
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;	  	// Acknowledge this interrupt to receive more interrupts from group 1
	GpioDataRegs.GPFTOGGLE.bit.GPIOF14 = 1;	  	// mignicie diod LED
}


//***************************************************************************************$
interrupt void MyEXternalVSign_isr(void)
{
	XIntruptRegs.XINT1CR.bit.POLARITY = (XIntruptRegs.XINT1CR.bit.POLARITY^0x0001); //zmiana na polaryzacj przeciwn dla pinu XINT1$
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;											// potwierdzenie przerwania dla grupy 1
}

//***************************************************************************************
interrupt void MyTimer2Period_isr(void)
{
	/*if (EvaRegs.GPTCONA.bit.T2STAT == TRUE)
		Motor1.NumberOfOverflows++;			// inkrementacja, gdy Timer2 zlicza w gr
	else
		Motor1.NumberOfOverflows--;			// dekrementacja, gdy Timer2 zlicza w d
	*/
	EvaRegs.EVAIMRB.bit.T2PINT = 1;	
	EvaRegs.EVAIFRB.all = BIT0;				// skasowanie zgoszenia przerwania od T2P
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;	// potwierdzenie przerwania dla grupy 3
}

//***************************************************************************************
interrupt void MyTimer2Compare_isr(void)
{
	EvaRegs.EVAIMRB.bit.T2CINT = 1;	
	EvaRegs.EVAIFRB.all = BIT1;				// skasowanie zgoszenia przerwania od T2C
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;	// potwierdzenie przerwania dla grupy 3
}

//***************************************************************************************
interrupt void MyTimer2Underflow_isr(void)
{
	EvaRegs.EVAIMRB.bit.T2UFINT = 1;	
	EvaRegs.EVAIFRB.all = BIT2;				// skasowanie zgoszenia przerwania od T2OF
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;	// potwierdzenie przerwania dla grupy 3
}

//***************************************************************************************
interrupt void MyTimer2Overflow_isr(void)
{
	EvaRegs.EVAIMRB.bit.T2OFINT = 1;	
	EvaRegs.EVAIFRB.all = BIT3;				// skasowanie zgoszenia przerwania od T2OF
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;	// potwierdzenie przerwania dla grupy 3
}

//***************************************************************************************
interrupt void MyTimer4Period_isr(void)
{
	/*if (EvbRegs.GPTCONB.bit.T4STAT == TRUE)
		Motor2.NumberOfOverflows++;			// inkrementacja, gdy Timer4 zlicza w gr
	else
		Motor2.NumberOfOverflows--;			// dekrementacja, gdy Timer4 zlicza w d-
	*/
	EvbRegs.EVBIMRB.bit.T4PINT = 1;	
	EvbRegs.EVBIFRB.all = BIT0;				// skasowanie zgoszenia przerwania od T4P
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP5;	// potwierdzenie przerwania dla grupy 5
}

//***************************************************************************************
interrupt void MyTimer4Compare_isr(void)
{
	EvbRegs.EVBIMRB.bit.T4CINT = 1;	
	EvbRegs.EVBIFRB.all = BIT1;				// skasowanie zgoszenia przerwania od T4UF
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP5;	// potwierdzenie przerwania dla grupy 5
}

//***************************************************************************************
interrupt void MyTimer4Underflow_isr(void)
{
	EvbRegs.EVBIMRB.bit.T4UFINT = 1;	
	EvbRegs.EVBIFRB.all = BIT2;				// skasowanie zgoszenia przerwania od T4UF
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP5;	// potwierdzenie przerwania dla grupy 5
}

//***************************************************************************************
interrupt void MyTimer4Overflow_isr(void)
{
	EvbRegs.EVBIMRB.bit.T4OFINT = 1;	
	EvbRegs.EVBIFRB.all = BIT3;				// skasowanie zgoszenia przerwania od T4OF
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP5;	// potwierdzenie przerwania dla grupy 5
}

