//###########################################################################
//
// Moje struktury danych i deklaracje zmiennych
//
//###########################################################################

#ifndef MYDATA_H
	#define MYDATA_H
#endif

#define	GLOBAL_Q	14

#ifndef __IQMATHLIB_H_INCLUDED__
	#include "IQmathLib.h"
#endif


//*****************************************************************************

typedef struct{
   Uint16	ABzone:1;		   // 0		flaga pobytu w strefie A/B
   Uint16	Fslope:1;		   // 1 	flaga wskazujca zbocze (przejcie z FFFF na 0 lub z 0 na FFFF)
   Uint16	ControlMode:2;	   // 2:3   wybr trybu wymuszenia (napiciowe U/B lub prdowe)
   Uint16	GenType:2;		   // 4:5	wybr typu generatora sygnaw referncyjnych
   Uint16	rsvd3:10;          // 6:15  reserved
}StatusBits;

typedef union{
   Uint16         all;
   StatusBits	  bit;
}STATUS_BITS;


//*****************************************************************************
typedef struct{
	int32	NumberOfOverflows;
	int32	ImpulseOffset;
	int32	ImpulseOffset_1;
	int32	DeltaPos;
		
	int32	PositionIMP;		// pozycja w [imp]
	_iq 	PositionRAD;		// pozycja w [rad]
	_iq		PositionREV;		// pozycja w [obr] 
	
	// rejestry wykorzystywane do oblicze prdkoci:
	_iq		Position_old;  		/* pozycja napdu z chwili n-1 */
    _iq		K;         			/* wspczynnik do obliczania prdkoci */
   		
	// rejestry prdkoci obliczanych na podstawie QEP:
	_iq		VelocityQEPNor;		// znormalizowana prdko (zakres [-1,1]); normalizacja wzgldem prdkoci maksymalnej = 125000 [imp/s]
	_iq		VelocityQEPIMP;		// prdko w [imp/s] 
	_iq		VelocityQEPRAD;		// prdko w [rad/s] 
	_iq		VelocityQEPREV;		// prdko w [obr/s] 

	// wspczynniki do przelicze prdkoci:
	_iq		RPS_max;
	_iq		RadPS_max;
	_iq		IPS_max;
}MotorStruct;


//*****************************************************************************
typedef	struct{
	_iq		X1ref;  			/* Input: Reference input for X1 state variable */
	_iq		X2ref;  			/* Input: Reference input for X2 state variable */
	_iq		X2ref_p;			/* pochodna referencyjnego sygnau X2 (adowana przez generator ref.) */
	_iq		X1;   				/* Feedback from X1 */
	_iq		X2;   				/* Feedback from X2 */
	_iq		e1;					/* Error: e1 = X1ref - X1 */
	_iq		e2;					/* Error: e2 = X2ref - X2 */
	_iq		K1;					/* wspczynnik sprzenia zwrotnego K1 */
	_iq		K2;					/* wspczynnik sprzenia zwrotnego K2 */
	_iq		uk;					/* sprzenie od stanu */
	_iq		uff;				/* sprzenie wyprzedzajce*/
	_iq		Kf0;				/* wspczynnik sprzenia wyprzedzajcego*/
	_iq		Kf1;				/* wspczynnik sprzenia wyprzedzajcego*/
	_iq		c_presat;			/* sterowanie przed nasyceniem */
	_iq		C_out;   			/* sterowanie po nasyceniu */
}StateRegStruct;


typedef	struct{
	_iq		SscalerUU;			/* wspczynnik skalujcy do fizycznej realizacji sterowania napiciowego unipolarnego */
	_iq		SscalerUB;			/* wspczynnik skalujcy do fizycznej realizacji sterowania napiciowego bipolarnego */
	_iq		SscalerI;			/* wspczynnik skalujcy do fizycznej realizacji sterowania prdowego */
	_iq		C_out_max;			/* dopuszczalna maksymalna warto sterowania */
	_iq		C_out_min;			/* dopuszczalna minimalna warto sterowania */
}ConSigStruct;


//*****************************************************************************
typedef	struct{
	_iq		A;					/* amplituda dla generatora */
	_iq		F;					/* czstotliwo dla generatora */
	//***************
	_iq		GenOut;				/* wyjcie biece generatora (bez filtru)*/
	_iq	 	GenOut_p;			/* pochodna sygnau zadanego */
	_iq 	GenOut_pp;			/* druga pochodna sygnau zadanego */
}GeneratorStruct;

//**********************************************************************************************
//**********************************************************************************************
extern MotorStruct		Motor1;
extern GeneratorStruct	Generator1;
extern StateRegStruct	Regulator1;
extern MotorStruct		Motor2;
extern GeneratorStruct	Generator2;
extern StateRegStruct	Regulator2;
extern ConSigStruct		CSignals1;
extern ConSigStruct		CSignals2;
extern STATUS_BITS		STATUS;
extern _iq 				GenTime;
extern Uint16			DataCount, NumberOfSamples, j, WisDataSize;

extern const _iq		PI_2IQ21;
extern const _iq 		dTgIQ21;
extern const _iq		invdTgIQ21;
extern const _iq 		dTgIQ;
extern const _iq 		Affp, Affn, Bffp, Bffn;
extern const _iq 		PWM0BIQ19;
extern const _iq		FullResIQ9;
extern const _iq		FullResIQ11;
extern const _iq		RPS_maxpIQ14, RadPS_maxpIQ14, IPS_maxpQ13;
extern const _iq 		TwoPIIQ21;
extern const _iq 		TwoPIIQ;
extern const _iq		TpIQ21;
extern const _iq		RadPS_maxpIQ21;
extern const _iq		PIIQ21;
extern const _iq	    InvPIIQ21;
extern const _iq		Tp_2IQ21;
extern const _iq		TpIQ14;
extern const _iq		invTpIQ;
extern const _iq		CoeffM1;


